//*********************************************************************************
// RInfo.cpp - 
//
// Half-Life Sprite Viewer - Written by David Flor, (c) 1999 Mach III Enterprises
//*********************************************************************************
// "Sprite Information" dialog
//*********************************************************************************

#include "stdafx.h"
#include "sprview.h"

LRESULT CALLBACK InfoDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			char tStr[256];

			if (!gCurrentSprite)
				return FALSE;

			SetWindowText(GetDlgItem(hDlg, IDT_SPRITENAME), spriteName);
			
			sprintf(tStr, "%.3f", gCurrentSprite->header.boundingradius);
			SetWindowText(GetDlgItem(hDlg, IDT_RADIUS), tStr);

			sprintf(tStr, "%ld x %ld", gCurrentSprite->header.width, gCurrentSprite->header.height);
			SetWindowText(GetDlgItem(hDlg, IDT_SIZE), tStr);

			sprintf(tStr, "%ld", gCurrentSprite->header.numframes);
			SetWindowText(GetDlgItem(hDlg, IDT_TOTALFRAMES), tStr);

			switch (gCurrentSprite->header.texFormat)
			{
				case SPR_NORMAL:
					strcpy(tStr, "Normal");
					break;
				case SPR_ADDITIVE:
					strcpy(tStr, "Additive");
					break;
				case SPR_INDEXALPHA:
					strcpy(tStr, "Indexed Alpha");
					break;
				case SPR_ALPHTEST:
					strcpy(tStr, "Alpha Test");
					break;
			}
			SetWindowText(GetDlgItem(hDlg, IDT_TEXTURETYPE), tStr);

			return TRUE;
		}


		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				case IDCANCEL:
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
			}
			break;
		}
	}
    
	return FALSE;
}

